package mole 
{
	import mole.hud.IHUDEventListener;
	
	/**
	 * Gestionnaire d'interface de jeu.
	 * @author Cédric Liaudet
	 */
	public class CHUDManager 
	{
		/**
		 * Constructeur par défaut.
		 */
		public function CHUDManager() 
		{
			
		}
		
		/**
		 * Envoi d'un evenement.
		 * @param	_sEventName Le nom de l'event
		 * @param	_sEventValue Tableau de valeur associer a l'event.
		 */
		public function OnHUDEvent(_sEventName:String, _sEventValue:Array):void
		{
			var aListeners:Array = m_aHUDEvent[_sEventName];
			for each(var listener:IHUDEventListener in aListeners)
			{
				listener.OnHUDEvent(_sEventName, _sEventValue);
			}
		}
		
		/**
		 * Ajout d'un listener.
		 * @param	_sEventName Le nom de l'event.
		 * @param	_EventListener Le listener.
		 */
		public function AddListener(_sEventName:String, _EventListener:IHUDEventListener):void
		{
			if (_EventListener)
			{
				var aListeners:Array = m_aHUDEvent[_sEventName];
				if (aListeners)
					aListeners.push(_EventListener);
				else
					m_aHUDEvent[_sEventName] = new Array([_EventListener]);
			}
		}
		
		/**
		 * Suppression du listener de l'event spécifier.
		 * @param	_sEventName Le nom de l'event.
		 * @param	_EventListener Le listener.
		 */
		public function RemoveListener(_sEventName:String, _EventListener:IHUDEventListener):void
		{
			if (_EventListener)
			{
				var aListeners:Array = m_aHUDEvent[_sEventName];
				if (aListeners)
				{
					for (var i:int = 0; i < aListeners.length; i++)
					{
						var listener:IHUDEventListener = aListeners[i];
						
						if (listener == _EventListener)
						{
							var lastListener:IHUDEventListener = aListeners.pop();
							if (lastListener != listener && aListeners.length)
							{
								aListeners[i] = lastListener;
							}
						}
					}
				}
			}
		}
		
		/**
		 * Suppression d'un event
		 * @param	_sEventName Nom de l'event a supprimer.
		 */
		public function RemoveEvent(_sEventName:String):void
		{
			if (m_aHUDEvent[_sEventName])
			{
				m_aHUDEvent[_sEventName] = null;
			}
		}
		
		/**
		 * Suppression de tout les events.
		 */
		public function RemoveAllEvents():void
		{
			m_aHUDEvent = { };
		}
		
		private var m_aHUDEvent:Object = { }; ///< Les listeners d'evenements.  
	}

}